#include "EntityManager.h"

namespace SimulationEngine
{

EntityManager *EntityManager::instance = 0;

EntityManager::EntityManager()
{
}

EntityManager *EntityManager::GetInstance()
{
	if (instance==0)
		instance =  new EntityManager();
	return instance;
}

ISimEntity *EntityManager::GetEntity(int entityid)
{
	std::list<ISimEntity *>::iterator iter;
	bool found = false;
	ISimEntity *toreturn=0;
	iter = entities.begin();
	while (!found && iter!=entities.end())
	{
		if (entityid== (*iter)->GetEntityId())
		{
			toreturn = (*iter);
			found = true;
		}
		else
			iter++;
	}
	return toreturn;
}

void EntityManager::DestroyEntities()
{
	std::list<ISimEntity *>::iterator iter;
	iter = entities.begin();
	while (iter!=entities.end())
	{
		ISimEntity *todestroy = (*iter);
		delete todestroy;
		iter++;
	}
	entities.clear();
}

string EntityManager::GetEntitiesString()
{
	string toret = "<Entities_Info>";
	std::list<ISimEntity *>::iterator iter;
	iter = entities.begin();
	while (iter!=entities.end())
	{
		toret += (*iter)->GetSimString();
		iter++;
	}
	toret += "</Entities_Info>";
	return toret;
}

void EntityManager::AddEntity(ISimEntity *entity)
{
	entities.push_back(entity);
}

string EntityManager::GetEntitiesPersist()
{
	string toret = "<Entities>";
	std::list<ISimEntity *>::iterator iter;
	iter = entities.begin();
	while (iter!=entities.end())
	{
		toret += (*iter)->PersistEntity();
		iter++;
	}
	toret += "</Entities>";
	return toret;
}

}
